#ifndef __CClassWriterWindow__
#define __CClassWriterWindow__

#include <EGUI.h>

namespace Exponent
{
	namespace ClassWrite
	{
		/**
		 * @class CClassWriterWindow CClassWriterWindow.hpp
		 * @brief Window interface to the class writer
		 *
		 * @date 08/12/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2007 Exp Digital Uk.\n
		 * This file forms part of the example projects for the Infinity API.\n
		 * You may not redistribute either the source code or the compiled binary.\n
		 * The Infinity API is covered by a fair use licence which you should have recieved with this\n
		 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
		 *
		 * $Id: CClassWriterWindow.hpp,v 1.3 2007/02/11 02:20:05 paul Exp $
		 */
		class CClassWriterWindow : public CWindow, public IActionListener
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================
			/**
			 * Construction
			 * @param size The size of the window
			 */
			CClassWriterWindow(const CRect &size);

			/**
			 * Destruction
			 */
			virtual ~CClassWriterWindow();

//	===========================================================================

			/**
			 * Handle action event
			 * @param event The event to handle
			 */
			virtual void handleActionEvent(const CActionEvent &event);

//	===========================================================================

		protected:

//	===========================================================================

			/**
			 * @enum EControlIds
			 * @brief Enumeration of the controls identifiers
			 */
			enum EControlIds
			{
				e_browseButton = 0,					/**< Button to browse for output path */
				e_doItButton,						/**< Button to trigger the process */
			};

//	===========================================================================

			/**
			 * Create the controls
			 */
			void createControls();

			/**
			 * Layout the radio buttons
			 */
			void layoutRadioButtons();

			/**
			 * Add the controls to the root
			 */
			void addControlsToRoot();

			/**
			 * Setup the drawing attributes
			 */
			void setupDrawingAttributes();

			/**
			 * Do process
			 */
			void doProcess();

			/**
			 * Tokenise the namespace argument
			 * @param namespaces The array that will hold the namespaces
			 * @param argument The arguments the user has supplied
			 */
			void tokeniseNamespaces(TStringCountedPointerArray &namespaces, const CString &arguments);

//	===========================================================================

			TAutomaticPointer<CMomentaryButton> m_doItButton;			/**< The do it button */
			TAutomaticPointer<CMomentaryButton> m_browseButton;			/**< The browser for output folder */
			TAutomaticPointer<CTextEdit> m_outputFolder;				/**< The output folder */
			TAutomaticPointer<CTextEdit> m_name;						/**< The name edit box */
			TAutomaticPointer<CTextEdit> m_namespaceEditBox;			/**< The name edit box */
			TAutomaticPointer<CRadioButton> m_objectType;				/**< The type of object */
			TAutomaticPointer<CRadioButton> m_parentType;				/**< The type of object */

		};
	}
}
#endif	// End of CClassWriterWindow.hpp